using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        var points = new (long x, long y)[N];

        for (int i = 0; i < N; i++)
        {
            var parts = Console.ReadLine().Split();
            long x = long.Parse(parts[0]);
            long y = long.Parse(parts[1]);
            points[i] = (x, y);
        }

        long greetings = 0;

        // --- 1) Horizontalni susreti (E ? W) ---
        var byY = new Dictionary<long, List<long>>();
        foreach (var p in points)
        {
            if (!byY.ContainsKey(p.y)) byY[p.y] = new List<long>();
            byY[p.y].Add(p.x);
        }

        foreach (var list in byY.Values)
        {
            list.Sort();
            int L = list.Count;
            int left = 0, right = L - 1;

            while (left < right)
            {
                long diff = list[right] - list[left];
                if ((diff & 1) == 0) greetings++;
                left++;
                right--;
            }
        }

        // --- 2) Vertikalni susreti (N ? S) ---
        var byX = new Dictionary<long, List<long>>();
        foreach (var p in points)
        {
            if (!byX.ContainsKey(p.x)) byX[p.x] = new List<long>();
            byX[p.x].Add(p.y);
        }

        foreach (var list in byX.Values)
        {
            list.Sort();
            int L = list.Count;
            int low = 0, high = L - 1;

            while (low < high)
            {
                long diff = list[high] - list[low];
                if ((diff & 1) == 0) greetings++;
                low++;
                high--;
            }
        }

        // --- 3) Dijagonale tip 1: (x+y) ---
        var diag1 = new Dictionary<long, List<(long x, long y)>>();
        foreach (var p in points)
        {
            long key = p.x + p.y;
            if (!diag1.ContainsKey(key)) diag1[key] = new List<(long, long)>();
            diag1[key].Add(p);
        }

        foreach (var list in diag1.Values)
        {
            list.Sort((a, b) => a.x.CompareTo(b.x));
            int L = list.Count;
            for (int i = 0; i < L; i++)
            {
                for (int j = i + 1; j < L; j++)
                {
                    long dx = list[j].x - list[i].x;
                    long dy = list[i].y - list[j].y;
                    if (dx == dy) greetings++;
                }
            }
        }

        // --- 4) Dijagonale tip 2: (x - y) ---
        var diag2 = new Dictionary<long, List<(long x, long y)>>();
        foreach (var p in points)
        {
            long key = p.x - p.y;
            if (!diag2.ContainsKey(key)) diag2[key] = new List<(long, long)>();
            diag2[key].Add(p);
        }

        foreach (var list in diag2.Values)
        {
            list.Sort((a, b) => a.x.CompareTo(b.x));
            int L = list.Count;
            for (int i = 0; i < L; i++)
            {
                for (int j = i + 1; j < L; j++)
                {
                    long dx = list[j].x - list[i].x;
                    long dy = list[j].y - list[i].y;
                    if (dx == dy) greetings++;
                }
            }
        }

        Console.WriteLine(greetings);
    }
}